﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Business.Db" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-06</title>
		<script runat="server">
	
	//Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
	static bool debug = false;
	
	//Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
	//przez listę a nie dla wszystkich
	static bool wgListy = false;
	
	//Nazwa cechy typu liczba całkowita dla definicji elementu z numerem wiersza,
	//w którym ma zostać umieszczona wartość danego elementu.
	//Jeżeli wartość "" to cecha nie jest odczytywana.
	static string nazwaCechy = "Pozycja GUS Z02";
	
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year;
            if (data.Month<7)
				rok --;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {				
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        [Priority(2)]
        public FromTo Okres {
			get { return FromTo.Year(rok); }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }

	FromTo rok;
	Date ostatni;
	
    void dc_ContextLoad(Object sender, EventArgs e) {
		TestCechy();
		
        ReportHeader["ROK"] = pars.Rok.ToString();
        rok = pars.Okres;
        ostatni = rok.To;
        YearMonth ym = new YearMonth(rok.From);
        for (int i=0; i<12; i++) {
			dni[i] = ym.Days;
			ym += 1;
		}
        
        int osoby1231 = 0;
        foreach (Pracownik pracownik in GetPracownicy()) {
			if (Zatrudniony(pracownik))
				osoby1231++;
				
			KalkulatorPracy kalk = new KalkulatorPracy(pracownik);
			foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(rok))
				AddZatrudnienie(ph, kalk);
				
			AddElementy(pracownik);			
        }

        osobyOgółem.EditValue = osoby1231;
        
        osobyPełn.EditValue = Przeciętnie(osobyP);
        osobyNiep.EditValue = Przeciętnie(osobyNP);
        etatyNiep.EditValue = Przeciętnie(etatyNP);
        osobyUczn.EditValue = Przeciętnie(osobyU);
        etatyUczn.EditValue = Przeciętnie(etatyU);

        czasPełn.EditValue = Czas(togółem[0]);
        czasNiep.EditValue = Czas(togółem[1]);
        czasUczn.EditValue = Czas(togółem[2]);

        normaPełn.EditValue = Czas(tnorma[0]);
        normaNiep.EditValue = Czas(tnorma[1]);
        normaUczn.EditValue = Czas(tnorma[2]);
        
        nadliczPełn.EditValue = Czas(tnadlicz[0]);
        nadliczNiep.EditValue = Czas(tnadlicz[1]);
        nadliczUczn.EditValue = Czas(tnadlicz[2]);
        
        płatnePełn.EditValue = Czas(tpłatne[0]);
        płatneNiep.EditValue = Czas(tpłatne[1]);
        płatneUczn.EditValue = Czas(tpłatne[2]);

        prac01.EditValue = kwotyPrac[01];
        uczn01.EditValue = kwotyUczn[01];
        
        prac02.EditValue = kwotyPrac[02];
        uczn02.EditValue = kwotyUczn[02];
        
        prac03.EditValue = kwotyPrac[03];
        prac04.EditValue = kwotyPrac[04];
        prac05.EditValue = kwotyPrac[05];
        prac06.EditValue = kwotyPrac[06];
        prac07.EditValue = kwotyPrac[07];
        prac08.EditValue = kwotyPrac[08];
        prac09.EditValue = kwotyPrac[09];
        prac10.EditValue = kwotyPrac[10];
        prac11.EditValue = kwotyPrac[11];
        prac12.EditValue = kwotyPrac[12];
        prac13.EditValue = kwotyPrac[13];
        prac14.EditValue = kwotyPrac[14];
        prac15.EditValue = kwotyPrac[15];
        prac16.EditValue = kwotyPrac[16];
        prac17.EditValue = kwotyPrac[17];
        prac18.EditValue = kwotyPrac[18];
        prac19.EditValue = kwotyPrac[19];
        
        prac20.EditValue = kwotyPrac[20];
        uczn20.EditValue = kwotyUczn[20];
        
        prac21.EditValue = kwotyPrac[21];
        prac22.EditValue = kwotyPrac[22];
        prac23.EditValue = kwotyPrac[23];
        
        prac24.EditValue = kwotyPrac[24];
        uczn24.EditValue = kwotyUczn[15]+kwotyUczn[16]+kwotyUczn[17]+kwotyUczn[18]+kwotyUczn[19]
						  +kwotyUczn[21]+kwotyUczn[22]+kwotyUczn[23]+kwotyUczn[24];
        
        prac25.EditValue = kwotyPrac[25];
        uczn25.EditValue = kwotyUczn[25];
        
        prac26.EditValue = kwotyPrac[26];
        prac27.EditValue = kwotyPrac[27];
        prac28.EditValue = kwotyPrac[28];
    }

	void TestCechy() {
		if (nazwaCechy!="") {
			FeatureDefs fd = BusinessModule.GetInstance(dc).FeatureDefs;
			bool update = fd.ByName[typeof(DefElementow).Name, nazwaCechy]!=null;
			if (!update)
				nazwaCechy = "";
		}
	}
	
    decimal[] kwotyPrac = new decimal[29];
    decimal[] kwotyUczn = new decimal[29];
    
    Time[] togółem = new Time[3];
    Time[] tnorma = new Time[3];
    Time[] tnadlicz = new Time[3];
    Time[] tpłatne = new Time[3];

            void AddElementy(Pracownik pracownik) {
                SubTable st = PlaceModule.GetInstance(pracownik).WypElementy.WgPracownik[pracownik];
                st = new SubTable(st, rok);

                foreach (WypElement element in st)
                    if (element.Definicja.GUS.WykazujNaDeklaracjach) {
                        bool uczeń;
                        PracHistoria ph = element.PracHistoria;
                        if (GetZatrudniony(ph, out uczeń)) {
                            AddElementCzas(element, ph, uczeń);
                            AddElementKwota(element, ph, uczeń);
                        }
                    }
            }

	void AddElementKwota(WypElement element, PracHistoria ph, bool uczeń) {
		decimal zus = element.Podatki.FirmaZUS;
		decimal fp = element.Podatki.FP.Skladka + element.Podatki.FGSP.Skladka;
		
		decimal[] kwoty = uczeń ? kwotyUczn : kwotyPrac;
		
		kwoty[20] += zus;
		kwoty[21] += fp;
		
		int pozycja = 0;
		decimal dopłata = 0;
		if (nazwaCechy!="")
			pozycja = element.Definicja.Features.GetInt(nazwaCechy);
		if (pozycja==0)
			pozycja = PozycjaElementu(element, ph, ref dopłata);
			
		if (pozycja>0 && pozycja<99) {
			decimal wartość = element.Wartosc;
			Dodaj(kwoty, pozycja, wartość - dopłata);
			Dodaj(kwoty, 07, dopłata);				
		}
	}
	
	void Dodaj(decimal[] kwoty, int pozycja, decimal wartość) {
		if (wartość!=0m) {
			kwoty[pozycja] += wartość;
			if (03<=pozycja && pozycja<=14) {
				kwoty[01] += wartość;
				kwoty[02] += wartość;
			}
			else if (15<=pozycja && pozycja<=24)
				kwoty[01] += wartość;
			else if (26<=pozycja && pozycja<=28)
				kwoty[25] += wartość;
		}
	}

	int PozycjaElementu(WypElement element, PracHistoria ph, ref decimal dopłata) {
		switch (element.Definicja.GUS.Kategoria) {
			case KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku:
				return 26;
			case KategoriaWynagrodzeniaGUS.DodatkoweWynagrodzenieRoczne:
				return 15;
			case KategoriaWynagrodzeniaGUS.Honorarium:
				return 17;
			//case KategoriaWynagrodzeniaGUS.WynagrodzenieAkwizycyjnoProwizyjne:
			//	throw new Exception("KategoriaWynagrodzeniaGUS.WynagrodzenieAkwizycyjnoProwizyjne");
			case KategoriaWynagrodzeniaGUS.WgDefinicjiElementu:
				if (element.Definicja.Info.Opodatkowany && !element.ZasiłekZus && !element.ZasiłekBudżet)
					if (element.Wyplata.Typ==TypWyplaty.Umowa) {
						if (Honorarium(element))
							return 17;
						else if (UmowaZlecenie(element))
							return 16;
					}
					else {
						switch (element.RodzajZrodla) {
							case RodzajŹródłaWypłaty.NadgodzinyI:
							case RodzajŹródłaWypłaty.NadgodzinyII:
							case RodzajŹródłaWypłaty.NadgodzinyŚw:
								return 07;
							case RodzajŹródłaWypłaty.Etat:
								foreach (WypSkladnik s in element.Skladniki)
									switch (s.Rodzaj) {
										case RodzajSkładnikaWypłaty.OdchyłkaPlus:
										case RodzajSkładnikaWypłaty.OdchyłkaMinus:
											dopłata += s.Wartosc; 
											break;
										}
								
								if (dopłata<0m)
									dopłata = 0m;
								return 03;
							case RodzajŹródłaWypłaty.Nieobecność:
								Nieobecnosc n = ((WypElementNieobecność)element).Nieobecność;
								if (n!=null)
									switch (n.Definicja.Przyczyna) {
										case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
											return 10;
										case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
										case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
											return 8;
									}
								return 11;
							case RodzajŹródłaWypłaty.Kurs:
								return 18;
							case RodzajŹródłaWypłaty.Świadczenie:
								return 27;
							case RodzajŹródłaWypłaty.Nagroda:
								return 06;
							default:
								return 14;
						}
					}
				break;
			default:
				throw new Exception("Nieoczekiwana wartość pola element.Definicja.GUS.Kategoria: " + element.Definicja.GUS.Kategoria);						
		}
		
		return 0;
	}

	bool Honorarium(WypElement element) {
		PozycjaPIT pit = element.Definicja.Deklaracje.PozycjaPIT;
		return pit!=null && pit.PIT8B==70;
	}
	
	bool UmowaZlecenie(WypElement element) {
		switch (element.Definicja.Deklaracje.Umowa) {
			case TypUmowyCywilnoPrawnej.UmowaODzieło:
			case TypUmowyCywilnoPrawnej.UmowaZlecenia:
				return true;
		}
		return false;
	}

	void AddElementCzas(WypElement element, PracHistoria ph, bool uczeń) {
		Time norma = Time.Zero;
		Time plus = Time.Zero;
		Time minus = Time.Zero;
		Time nieob = Time.Zero;
		Time płatne = Time.Zero;
		switch (element.RodzajZrodla) {
			case RodzajŹródłaWypłaty.Etat:
				foreach (WypSkladnik s in element.Skladniki)
					switch (s.Rodzaj) {
						case RodzajSkładnikaWypłaty.Główny:
							norma += s.Czas; break;
						case RodzajSkładnikaWypłaty.OdchyłkaPlus:
							plus += s.Czas; break;
						case RodzajSkładnikaWypłaty.OdchyłkaMinus:
							minus -= s.Czas; break;						
						case RodzajSkładnikaWypłaty.PomniejszenieProp:
						case RodzajSkładnikaWypłaty.Pomniejszenie130:
						case RodzajSkładnikaWypłaty.PomniejszenieZaDzień:
						case RodzajSkładnikaWypłaty.PomniejszenieStorno:
							nieob -= s.Czas; break;						
						case RodzajSkładnikaWypłaty.Korekta:
						case RodzajSkładnikaWypłaty.OdchyłkaAkordMinus:
							break;
						default:
							throw new Exception("Nieoczekiwana wartość pola Rodzaj (składnika): " + s.Rodzaj);
					}
				break;
				
			case RodzajŹródłaWypłaty.Nieobecność:
				if (!element.ZasiłekZus && !element.ZasiłekBudżet) {
					płatne = element.Czas;
					if (płatne==Time.Zero) {
						KalkulatorPlanu kp = new KalkulatorPlanu(element.Pracownik);
						płatne = kp.Norma(element.Okres).Czas;
					}
				}
				break;
			
			default:
				return;
		}
		
		int idx = uczeń ? 2 : ph.Etat.Zaszeregowanie.Wymiar!=Fraction.One ? 1 : 0;
		Time odchyłka = plus - minus;
		togółem[idx] += norma + odchyłka + płatne - nieob;
		tnorma[idx] += norma - nieob;
		tpłatne[idx] += płatne;				
		if (odchyłka>Time.Zero)
			tnadlicz[idx] += odchyłka;
		else
			tnorma[idx] += odchyłka;
	}
    	
	int[] dni = new int[12];
    decimal[] osobyP = new decimal[12];
    decimal[] osobyNP = new decimal[12];
    decimal[] osobyU = new decimal[12];
    decimal[] etatyNP = new decimal[12];
    decimal[] etatyU = new decimal[12];
    
	void AddZatrudnienie(PracHistoria ph, KalkulatorPracy kalk) {
		bool uczeń;
		if (GetZatrudniony(ph, out uczeń)) {			
			FromTo zatrudniony = ph.Etat.EfektywnyOkres * rok;
			Periods okresy = Periods.New(zatrudniony);
			foreach (INieobecnosc nieobecność in kalk.Nieobecnosci(zatrudniony, true))
				switch (nieobecność.Definicja.Przyczyna) {
					case PrzyczynaNieobecnosci.UrlopWychowawczy:
					case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
					case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
					case PrzyczynaNieobecnosci.UrlopBezpłatny:
						okresy -= nieobecność.Okres;
						break;
				}
				
			okresy = okresy.BreakByMonth();
						
			foreach (FromTo okres in okresy) {
				int m = okres.From.Month - 1;
				decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
				if (uczeń) {
					osobyU[m] += okres.Days;
					etatyU[m] += okres.Days * w;
				}
				else if (w!=1m) {
					osobyNP[m] += okres.Days;
					etatyNP[m] += okres.Days * w;
				}
				else
					osobyP[m] += okres.Days;
			}
		}
	}
    
    bool GetZatrudniony(PracHistoria ph, out bool uczeń) {
		uczeń = false;
		switch (ph.Etat.RodzajZatrudnienia) {
			case RodzajZatrudnienia.NieDotyczy:
            case RodzajZatrudnienia.PracownikTymczasowy:
			case RodzajZatrudnienia.CzłonekRSP:
			case RodzajZatrudnienia.CzłonekSKR:
			case RodzajZatrudnienia.Student:
			case RodzajZatrudnienia.Absolwent:
				return true;
						
			case RodzajZatrudnienia.Uczeń1Klasy:
			case RodzajZatrudnienia.Uczeń2Klasy:
			case RodzajZatrudnienia.Uczeń3Klasy:
			case RodzajZatrudnienia.MłodocianyPrzyuczany:
				uczeń = true;
				return true;

			case RodzajZatrudnienia.Właściciel:
			case RodzajZatrudnienia.OsobaWspółpracująca:
			case RodzajZatrudnienia.Chałupnik:
			case RodzajZatrudnienia.PracownikZaGranicą:
            case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                //Agent
				return false;
			
			default:
				throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
		}
    }
    
    bool Zatrudniony(Pracownik pracownik) {
		PracHistoria ph = pracownik[ostatni];
		if (ph.GUS.GlowneMiejscePracy && ph.Etat.EfektywnyOkres.Contains(ostatni))
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
                case RodzajZatrudnienia.PracownikTymczasowy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
				case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
				case RodzajZatrudnienia.Chałupnik:
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    //Agent
					return true;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
					break;
				
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}
			
		return false;
    }
        
    IEnumerable GetPracownicy() {
		ArrayList lista = new ArrayList();
		if (wgListy) {
			Row[] rows = (Row[])dc[typeof(Row[])];
			foreach (Pracownik idx in rows)
				lista.Add(idx);
		}
		else {
			KadryModule kadry = KadryModule.GetInstance(dc);        
			lista.AddRange(kadry.Pracownicy.WgKodu);
		}
		
		return lista;
    }
    
    public decimal Przeciętnie(decimal[] lista) {
		decimal result = 0m;
		for (int i=0; i<12; i++)
			result += lista[i] / dni[i];
		result /= 12;
		return debug ? Decimal.Round(result,2) : Decimal.Floor(result);
    }

    public decimal Tys(decimal value) {
		if (debug)
			return value;
		return Soneta.Tools.Math.Round(value/1000m, 1);
    }
    
    public object Czas(Time t) {
		if (debug)
			return t;
		return Soneta.Tools.Math.Round(t.TotalHours/1000.0, 1);
    }
    
    static void Msg(object value) {
    }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext><eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS Z-02|</strong>Rok: <strong>%ROK%" runat="server"></eb:reportheader>
			<P><STRONG>Dział 1. INFORMACJE O JEDNOSTCE</STRONG></P>
			<P>
				<TABLE id="Table1" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD width="80%"><STRONG>1. Proszę podać liczbę pracujących w osobach - stanw dniu 31 
								XII 2004 r.</STRONG>
							<BR>
							<EM>(w głównym miejscu pracy)</EM>
						</TD>
						<TD align="right"><ea:datalabel id="osobyOgółem" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD><STRONG>2. Proszę podać poniesione w roku koszty ogółem w tyś zł</STRONG><BR>
							<EM>(z jednym miejscem po przecinku)</EM>
						</TD>
						<TD>&nbsp;</TD>
					</TR>
				</TABLE>
			</P>
			<P><STRONG>Dział 2. ZATRUDNIENIE</STRONG> <EM>(w osobach, bez znaku po przecinku)</EM></P>
			<P>
				<TABLE id="Table2" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD width="80%" colSpan="2"><STRONG>1. Proszę podać przeciętną liczbę osób 
								pełnozatrudnionych</STRONG></TD>
						<TD align="right"><ea:datalabel id="osobyPełn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="45%"><STRONG>2. Proszę podać przeciętną liczbę osób niepełnozatrudnionych</STRONG></TD>
						<TD>2.1 bez przeliczenia na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="osobyNiep" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>2.2 w przeliczeniu na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="etatyNiep" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD><STRONG>3. Proszę podać przeciętną liczbę osób (uczniów) zatrudnionych na podstawie 
								umowy o pracę w celu przygotowania zawodowego</STRONG></TD>
						<TD>3.1 bez przeliczenia na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="osobyUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>3.2 w przeliczeniu na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="etatyUczn" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<P><STRONG>Dział 3. CZAS PRACY</STRONG> <EM>(w tyś. godzin z jednym znakiem po 
					przecinku)</EM></P>
			<P>
				<TABLE id="Table3" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="25%">Wyszczególnienie</TD>
						<TD align="center" width="25%">Pełnozatrudnieni</TD>
						<TD align="center" width="25%">Niepełnozatrudnieni</TD>
						<TD align="center" width="25%">Uczniowie</TD>
					</TR>
					<TR>
						<TD align="center"><FONT size="2">0</FONT></TD>
						<TD align="center"><FONT size="2">1</FONT></TD>
						<TD align="center"><FONT size="2">2</FONT></TD>
						<TD align="center"><FONT size="2">3</FONT></TD>
					</TR>
					<TR>
						<TD><STRONG>Ogółem</STRONG> - liczba godzin opłaconych (w. 2 do 4)</TD>
						<TD align="right"><ea:datalabel id="czasPełn" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="czasNiep" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="czasUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Godziny przepracowane w czasie normalnym</TD>
						<TD align="right"><ea:datalabel id="normaPełn" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="normaNiep" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="normaUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Godziny przepracowane w czasie nadliczbowym</TD>
						<TD align="right"><ea:datalabel id="nadliczPełn" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nadliczNiep" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nadliczUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Godziny nieprzepracowane<BR>
						</TD>
						<TD align="right"><ea:datalabel id="płatnePełn" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="płatneNiep" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="płatneUczn" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak1" runat="server"></ea:pagebreak>
			<P><STRONG>Dział 4. SKŁADNIKI KOSZTU PRACY</STRONG> <EM>(brutto w tyś. zł, z jednym 
					znakiem po przecinku)</EM></P>
			<P>
				<TABLE id="Table5" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem<BR>
							(pełno- i niepełnozatrudnieni)</TD>
						<TD align="center" width="25%">Uczniowie</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3"><FONT size="2">0</FONT></TD>
						<TD align="center"><FONT size="2">1</FONT></TD>
						<TD align="center"><FONT size="2">2</FONT></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2"><STRONG>Wynagrodzenie i świadczenia ogółem zaliczane w 
								ciężar kosztów jednostki </STRONG><EM>(suma wierszy 02 + 15 do 24)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">01</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac01" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn01" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenie osobowe ogółem<BR>
							<EM>(suma wierszy od 03 do 14)</EM></TD>
						<TD align="center"><FONT size="2">02</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac02" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn02" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="3%">&nbsp;</TD>
						<TD>wynagrodzenie zasadnicze</TD>
						<TD align="center"><FONT size="2">03</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac03" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>dodatki za staż pracy</TD>
						<TD align="center"><FONT size="2">04</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac04" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>premie wypłacane periodycznie za osiągnięcia w wykonywaniu podstawowych zadań</TD>
						<TD align="center"><FONT size="2">05</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac05" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>nagrody (bez wypłat z zysku)</TD>
						<TD align="center"><FONT size="2">06</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac06" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenie za pracę w godzinach nadliczbowych <EM>(w odniesieniu do godzin 
								wykazanych w dziale 3 wiersz 3)</EM></TD>
						<TD align="center"><FONT size="2">07</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac07" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenie za czas choroby <EM>(wypłacone wyłącznie ze środków zakładu pracy)</EM></TD>
						<TD align="center"><FONT size="2"><FONT size="2">08</FONT></FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac08" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenie za czas przestojów</TD>
						<TD align="center"><FONT size="2">09</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac09" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenie za czas urlopów wypoczynkowych</TD>
						<TD align="center"><FONT size="2">10</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac10" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>pozostałe wynagrodzenia za czas niewykonywania pracy</TD>
						<TD align="center"><FONT size="2">11</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac11" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>nagrody jubileuszowe, gratyfikacje</TD>
						<TD align="center"><FONT size="2">12</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac12" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>odprawy wypłacane po przejściu na emeryturę lub rentę</TD>
						<TD align="center"><FONT size="2">13</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac13" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>pozostałe składniki wynagrodzeń osobowych</TD>
						<TD align="center"><FONT size="2">14</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac14" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="Pagebreak2" runat="server"></ea:pagebreak>
			<P><STRONG>Dział 4. SKŁADNIKI KOSZTU PRACY</STRONG> <EM>(brutto w tyś. zł, z jednym 
					znakiem po przecinku) (dok.)</EM></P>
			<p>
				<TABLE id="Table4" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem<BR>
							(pełno- i niepełnozatrudnieni)</TD>
						<TD align="center" width="25%">Uczniowie</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3"><FONT size="2">0</FONT></TD>
						<TD align="center"><FONT size="2">1</FONT></TD>
						<TD align="center"><FONT size="2">2</FONT></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Dodatkowe wynagrodzenie roczne dla pracowników 
							jednostek sfery budżetowej</TD>
						<TD align="center" width="3%"><FONT size="2">15</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac15" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wynagrodzenia z tytułu umowy zlecenia lub umowy o 
							dzieło <EM>(wynagrodzenia bezosobowe - bez wypłat dla pracowników obcych)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">16</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac16" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Honoraria ogółem <EM>(bez wypłat dla pracowników obcych)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">17</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac17" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wydatki na doskonalenie, kształcenie i 
							przekwalifikowanie kadr</TD>
						<TD align="center" width="3%"><FONT size="2">18</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac18" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wydatki na delegacje służbowe</TD>
						<TD align="center" width="3%"><FONT size="2">19</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac19" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Składki na ubezpieczenie emerytalne, rentowe i 
							wypadkowe opłacone przez pracodawcę</TD>
						<TD align="center" width="3%"><FONT size="2">20</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac20" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn20" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Składki na fundusz pracy</TD>
						<TD align="center" width="3%"><FONT size="2">21</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac21" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wydatki związane z bezpieczeństwem i higieną pracy</TD>
						<TD align="center" width="3%"><FONT size="2">22</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac22" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Zakładowy fundusz świadczeń socjalnych <EM>(odpis w koszty)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">23</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac23" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Pozostałe wydatki</TD>
						<TD align="center" width="3%"><FONT size="2">24</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac24" runat="server" ></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn24" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2"><STRONG>Wypłaty z tytułu udziału w zysku do podziału lub z 
								nadwyżki bilansowej w spółdzielniach </STRONG><EM>(suma wierszy od 26 do 28)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">25</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac25" runat="server" ></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn25" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Nagrody i premie z tytułu udziału w zysku do podziału 
							lub z nadwyżki bilansowej w spółdzielniach</TD>
						<TD align="center" width="3%"><FONT size="2">26</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac26" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wypłaty na rzecz zakładowego funduszu świadczeń 
							socjalnych<EM> (odpis z zysku)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">27</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac27" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Inne wypłaty, jakie?<BR>
							. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .</TD>
						<TD align="center" width="3%"><FONT size="2">28</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac28" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
				</TABLE>
			</p>
			<P><eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter></P>
		</form>
	</body>
</HTML>

